const express = require("express");
const router = express.Router();
const cartController = require("../controllers/cartController");
const authController = require("../controllers/authController");
const checkApiKey = require("../utils/checkApiKey");
router.use(checkApiKey);
// All cart routes require login
router.use(authController.protect);

router
  .route("/")
  .get(cartController.getMyCart)
  .post(cartController.addToCart) // Expects { courseId: "..." } in body
  .delete(cartController.clearCart);

router.route("/:courseId").delete(cartController.removeFromCart);

module.exports = router;
